/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser.ast;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.util.ExprBytesUtils;
import team.unnamed.mocha.util.network.ProtocolUtils;

public final class AccessExpression
implements Expression {
    private final String property;
    private Expression object;

    public AccessExpression(ByteBuf buf) {
        this(ExprBytesUtils.readExpression(buf), ProtocolUtils.readString(buf));
    }

    public AccessExpression(@NotNull Expression object, @NotNull String property) {
        this.object = Objects.requireNonNull(object, "object");
        this.property = Objects.requireNonNull(property, "property");
    }

    @NotNull
    public Expression object() {
        return this.object;
    }

    public void object(@NotNull Expression object) {
        this.object = Objects.requireNonNull(object, "object");
    }

    @NotNull
    public String property() {
        return this.property;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitAccess(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ExprBytesUtils.writeExpression(this.object(), buf);
        ProtocolUtils.writeString(buf, this.property());
    }

    public String toString() {
        return String.format("%s.%s", this.object, this.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessExpression that = (AccessExpression)o;
        if (!this.object.equals(that.object)) {
            return false;
        }
        return this.property.equals(that.property);
    }

    public int hashCode() {
        int result = this.object.hashCode();
        result = 31 * result + this.property.hashCode();
        return result;
    }
}

